// Pool gesamt (alle Einsätze in diesem Rennen)
$stmtTotal = $pdo->prepare("
    SELECT IFNULL(SUM(amount),0)
    FROM bets
    WHERE race_id = ? AND status = 'placed'
");
$stmtTotal->execute([$raceId]);
$pool = (float)$stmtTotal->fetchColumn();

// Einsatz auf das Siegerpferd
$stmtWinner = $pdo->prepare("
    SELECT IFNULL(SUM(amount),0)
    FROM bets
    WHERE race_id = ? AND horse_id = ? AND status = 'placed'
");
$stmtWinner->execute([$raceId, $winnerHorseId]);
$onWinner = (float)$stmtWinner->fetchColumn();

$pdo->beginTransaction();

if ($pool <= 0.0) {
    // nichts auszuzahlen
} elseif ($onWinner <= 0.0) {
    // niemand hat auf den Sieger gesetzt -> alles verliert
    $pdo->prepare("
        UPDATE bets
        SET status='lost', payout=0, settled_at=NOW()
        WHERE race_id=? AND status='placed'
    ")->execute([$raceId]);
} else {
    $payoutFactor = $pool / $onWinner; // klassisch pari-mutuel, kein Hausanteil

    // Gewinner ausbezahlen
    $winners = $pdo->prepare("
        SELECT id, user_id, amount
        FROM bets
        WHERE race_id=? AND horse_id=? AND status='placed'
    ");
    $winners->execute([$raceId, $winnerHorseId]);

    $updBet  = $pdo->prepare("
        UPDATE bets
        SET status='won', payout=?, settled_at=NOW()
        WHERE id=?
    ");
    $updUser = $pdo->prepare("
        UPDATE users
        SET balance = balance + ?
        WHERE id=?
    ");

    foreach ($winners as $b) {
        $payout = round((float)$b['amount'] * $payoutFactor, 2);
        $updBet->execute([$payout, (int)$b['id']]);
        $updUser->execute([$payout, (int)$b['user_id']]);
    }

    // Verlierer markieren
    $pdo->prepare("
        UPDATE bets
        SET status='lost', payout=0, settled_at=NOW()
        WHERE race_id=? AND horse_id<>? AND status='placed'
    ")->execute([$raceId, $winnerHorseId]);
}

$pdo->prepare("UPDATE races SET settled_at=NOW() WHERE id=?")->execute([$raceId]);
$pdo->commit();

